<?php
/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package DotBlocks
 * @since 1.0
 */

if ( function_exists( 'register_block_style' ) ) {
	/**
	 * Register block styles.
	 *
	 * @since 1.0
	 *
	 * @return void
	 */
	function dot_blocks_register_block_styles() {
		// Button: Shadow.
		register_block_style(
			'core/button',
			array(
				'name'  => 'tegal-button-shadow',
				'label' => esc_html__( 'Shadow', 'tegal' ),
				'inline_style' => '
				.tegal-body .is-style-tegal-button-shadow , .tegal-admin-body .is-style-tegal-button-shadow {
					-webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, .1);
					box-shadow: 0 5px 10px rgba(0, 0, 0, .1);
				}
				.tegal-body .is-style-tegal-button-shadow:hover {
					-webkit-transform: translate(0, -2px);
					transform: translate(0, -2px);
					-webkit-box-shadow: 0 8px 15px rgba(0, 0, 0, .2);
					box-shadow: 0 8px 15px rgba(0, 0, 0, .2);
				}
				',
			)
		);
		// Image: Take the corner.
		register_block_style(
			'core/image',
			array(
				'name'  => 'tegal-image-take-corner',
				'label' => esc_html__( 'Take Corner', 'tegal' ),
				'inline_style' => '.tegal-body .is-style-tegal-image-take-corner > figure > img, .tegal-body figure.is-style-tegal-image-take-corner > img, .tegal-admin-body .is-style-tegal-image-take-corner > div:first-child > img {
					border-radius: 30px!important;
				}
				',
			)
		);
		// Image: Browser.
		register_block_style(
			'core/image',
			array(
				'name'  => 'tegal-image-browser',
				'label' => esc_html__( 'Browser', 'tegal' ),
				'inline_style' => '
				.tegal-body .is-style-tegal-image-browser > figure, .tegal-body figure.is-style-tegal-image-browser, .tegal-admin-body .is-style-tegal-image-browser > div:first-child {
					position:relative;
					padding: 48px 0 0 0;
					overflow: hidden;
					background: #FFFFFF;
					border: solid 6px #DEDEDE;
					border-top: none;
					border-radius: 8px!important;
					box-shadow: 0 3px 5px rgb(0 0 0 / 22%);
				}
				.tegal-body .is-style-tegal-image-browser > figure::before, .tegal-body figure.is-style-tegal-image-browser::before, .tegal-admin-body .is-style-tegal-image-browser > div:first-child::before {
					position:absolute;
					content: "";
					width: 100%;
					height: 24px;
					background: #DEDEDE url(' . get_template_directory_uri() . '/assets/images/image-style-parts-browser-button.png) no-repeat left 8px top 50%/auto 12px;
					display: block;
					top: 0;
					left: 0;
					padding: 0;
				}
				.tegal-body .is-style-tegal-image-browser > figure::after, .tegal-body figure.is-style-tegal-image-browser::after, .tegal-admin-body .is-style-tegal-image-browser > div:first-child::after {
					position:absolute;
					content: "";
					width: 100%;
					height: 24px;
					background: #F5F5F5 url(' . get_template_directory_uri() . '/assets/images/image-style-parts-browser-button2.png) no-repeat left 8px top 50%/auto 12px;
					display: block;
					top: 24px;
					left: 0;
					padding: 0;
				}
				.tegal-body .is-style-tegal-image-browser > figure img, .tegal-body figure.is-style-tegal-image-browser img, .tegal-admin-body .is-style-tegal-image-browser > div:first-child img {
					border-radius: 0!important;
				}
				.tegal-body .is-style-tegal-image-browser > figure > figcaption, .tegal-body figure.is-style-tegal-image-browser > figcaption, .tegal-admin-body .is-style-tegal-image-browser > div:first-child > figcaption {
					position: absolute;
					display: block;
					color: #000;
					top: 24px;
					left: 64px;
					padding: 0;
					margin: .2rem 0;
					z-index: 10;
				}
				',
			)
		);
		// Image: Tablet.
		register_block_style(
			'core/image',
			array(
				'name'  => 'tegal-image-tablet',
				'label' => esc_html__( 'Tablet', 'tegal' ),
				'inline_style' => '
				.tegal-body .is-style-tegal-image-tablet > figure, .tegal-body figure.is-style-tegal-image-tablet, .tegal-admin-body .is-style-tegal-image-tablet > div:first-child {
					position:relative;
					padding: 0 0 24px 0;
					background: #FFFFFF;
					border: solid 6px #030303;
					border-radius: 8px!important;
					box-shadow: 0 3px 5px rgb(0 0 0 / 22%);
				}
				.tegal-body .is-style-tegal-image-tablet > figure, .tegal-body figure.is-style-tegal-image-tablet {
					margin:0 0 2.8rem 0;
				}
				.tegal-body .is-style-tegal-image-tablet > figure::before, .tegal-body figure.is-style-tegal-image-tablet::before, .tegal-admin-body .is-style-tegal-image-tablet > div:first-child::before {
					position:absolute;
					content: "●";
					width: 100%;
					height: 24px;
					background: #030303;
					color:#EAEAEA;
					text-align:center;
					display: block;
					bottom: 0;
					left: 0;
					padding: 0;
				}
				.tegal-body .is-style-tegal-image-tablet > figure img, .tegal-body figure.is-style-tegal-image-tablet img, .tegal-admin-body .is-style-tegal-image-tablet > div:first-child img {
					border-radius: 0!important;
				}
				.tegal-body .is-style-tegal-image-tablet > figure > figcaption, .tegal-body figure.is-style-tegal-image-tablet > figcaption, .tegal-admin-body .is-style-tegal-image-tablet > div:first-child > figcaption {
					position: absolute;
					bottom: -50px;
					color: #000000;
					width: 100%;
					text-align: center;
				}
				',
			)
		);
		// Image: Tablet-sideways.
		register_block_style(
			'core/image',
			array(
				'name'  => 'tegal-image-tablet-syideways',
				'label' => esc_html__( 'Tablet-sideways', 'tegal' ),
				'inline_style' => '
				.tegal-body .is-style-tegal-image-tablet-syideways > figure, .tegal-body figure.is-style-tegal-image-tablet-syideways, .tegal-admin-body .is-style-tegal-image-tablet-syideways > div:first-child {
					position:relative;
					padding: 0 24px 0 0;
					overflow: hidden;
					background: #FFFFFF;
					border: solid 6px #030303;
					border-radius: 8px!important;
					box-shadow: 0 3px 5px rgb(0 0 0 / 22%);
				}
				.tegal-body .is-style-tegal-image-tablet-syideways > figure::before, .tegal-body figure.is-style-tegal-image-tablet-syideways::before, .tegal-admin-body .is-style-tegal-image-tablet-syideways > div:first-child::before {
					position:absolute;
					content: "●";
					width: 24px;
					height: 100%;
					background: #030303;
					color:#EAEAEA;
					text-align:center;
					 display: flex;
					 justify-content: center;
					 align-items: center; 
					top: 0;
					right: 0;
					padding: 0;
				}
				.tegal-body .is-style-tegal-image-tablet-syideways > figure img, .tegal-body figure.is-style-tegal-image-tablet-syideways img, .tegal-admin-body .is-style-tegal-image-tablet-syideways > div:first-child img {
					border-radius: 0!important;
				}
				',
			)
		);
		// Navigation: align left.
		register_block_style(
			'core/navigation',
			array(
				'name'  => 'tegal-navigation-overlay-align-left',
				'label' => esc_html__( 'Overlay align-left', 'tegal' ),
				'inline_style' => '.is-style-tegal-navigation-overlay-align-left .wp-block-navigation__responsive-container.is-menu-open .wp-block-navigation__responsive-container-content {
					align-items:flex-start;
					justify-content: flex-start;
				}
				.is-style-tegal-navigation-overlay-align-left .wp-block-navigation__responsive-container.is-menu-open .wp-block-navigation__responsive-container-content .wp-block-navigation__container, .is-style-tegal-navigation-overlay-align-left .wp-block-navigation__responsive-container.is-menu-open .wp-block-navigation__responsive-container-content .wp-block-page-list {
					align-items:flex-start;
					justify-content: flex-start;
					width:100%;
				}
				.is-style-tegal-navigation-overlay-align-left .wp-block-navigation__responsive-container.is-menu-open .wp-block-navigation__responsive-container-content .wp-block-pages-list__item {
					align-items: flex-start;
					width:100%;
				}
				.wp-block-pages-list__item__link {
					width:100%;
				}
				',
			)
		);
		// Query: card.
		register_block_style(
			'core/query',
			array(
				'name'  => 'tegal-query-card',
				'label' => esc_html__( 'Card', 'tegal' ),
				'inline_style' => '.is-style-tegal-query-card > ul > li {
					padding: 0.4rem;
					box-shadow: 0 3px 5px rgb(0 0 0 / 22%);
				}
				',
			)
		);
		// Columns : direction-col-reverse
		register_block_style(
			'core/columns',
			array(
				'name'  => 'tegal-column-direction-col-reverse',
				'label' => esc_html__( 'Direction Col Reverse', 'tegal' ),
				'inline_style' => '
				@media (max-width: 870px) {
					.is-style-tegal-column-direction-col-reverse {
						flex-direction: column-reverse;
					}
				}
				',
			)
		);
		// Columns : x-scroll
		register_block_style(
			'core/table',
			array(
				'name'  => 'tegal-table-x-scroll',
				'label' => esc_html__( 'Direction X Scroll', 'tegal' ),
				'inline_style' => '
				@media (max-width: 870px) {
					.is-style-tegal-table-x-scroll {
						overflow: auto;
						white-space: nowrap;
					}
					.is-style-tegal-table-x-scroll::-webkit-scrollbar{
						height: 5px;
					}
					.is-style-tegal-table-x-scroll::-webkit-scrollbar-track{
						background: #d3d3d3;
						border-radius: 10px;
					}
					.is-style-tegal-table-x-scroll::-webkit-scrollbar-thumb {
						background: #a9a9a9;
						border-radius: 10px;
					}
				}
				',
			)
		);
		// group: card.
		register_block_style(
			'core/group',
			array(
				'name'  => 'tegal-group-card',
				'label' => esc_html__( 'Card', 'tegal' ),
				'inline_style' => '.is-style-tegal-group-card {
					padding: 0.4rem;
					box-shadow: 0 3px 5px rgb(0 0 0 / 22%);
					height:100%;
				}
				',
			)
		);
		// group: steps.
		register_block_style(
			'core/group',
			array(
				'name'  => 'tegal-group-steps',
				'label' => esc_html__( 'Steps', 'tegal' ),
				'inline_style' => '.is-style-tegal-group-steps > div {
					position: relative;
				}
				.is-style-tegal-group-steps > div::before {
					position: absolute;
					content: "";
					width: 3px;
					background: #dcdcdc;
					display: block;
					top: 14px;
					bottom: -20px;
					left: -16px;
				}
				.is-style-tegal-group-steps > div:last-of-type::before{
					content:none
				}
				.is-style-tegal-group-steps > div::after {
					position: absolute;
					content: "";
					display: block;
					top: -6px;
					left: -24.2px;
					width: 14px;
					height: 14px;
					border-radius: 50%;
					border: solid 3px;
					background-color: #000000;
					border-color: #000000;
				}
				.is-style-tegal-group-steps > div:not(:first-of-type):not(:last-of-type)::after {
					background: 0 0;
				}
				.is-style-tegal-group-steps figure.wp-block-image {
					padding:1rem;
				}
				',
			)
		);
		// group: FAQ.
		register_block_style(
			'core/group',
			array(
				'name'  => 'tegal-group-faq',
				'label' => esc_html__( 'FAQ', 'tegal' ),
				'inline_style' => '
				.tegal-body .is-style-tegal-group-faq, .tegal-admin-body .is-style-tegal-group-faq {
					padding: 0 0 0.4rem 1.8rem;
					position:relative;
				}
				.tegal-body .is-style-tegal-group-faq > *:first-child::before, .tegal-admin-body .is-style-tegal-group-faq > *:first-child::before {
					position:absolute;
					left:-1rem;
					content:"Q";
					color:#FFFFFF;
					background-color:#191970;
					padding: 0 .5rem;
				}
				.tegal-body .is-style-tegal-group-faq > *:last-child::before, .tegal-admin-body .is-style-tegal-group-faq > *:last-child::before {
					position:absolute;
					left:-1rem;
					content:"A";
					color:#FFFFFF;
					background-color:#dc143c;
					padding: 0 .5rem;
				}
				',
			)
		);
	}
	add_action( 'init', 'dot_blocks_register_block_styles' );
}
