<?php
/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package tegal
 * @since 1.0
 */
if ( ! function_exists( 'tegal_blocks_setup' ) ) {
	function tegal_blocks_setup() {
		// translate textdomain
		load_theme_textdomain( 'tegal-blocks', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 1568, 9999 );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Enqueue editor styles.
		add_editor_style(
			array(
				'./assets/css/blocks.css',
				'./assets/css/style-shared.css',
			)
		);

		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );

		// Add block style setting
		add_theme_support( 'align-wide' );
		

	}
}
add_action( 'after_setup_theme', 'tegal_blocks_setup' );

/**
 * Enqueue scripts and styles.
 *
 * @since 1.0
 *
 * @return void
 */
function tegal_blocks_scripts() {
//filemtime( get_stylesheet_directory() . '/style.css')
	wp_enqueue_style( 'tegal-blocks-style', get_template_directory_uri() . '/style.css', array(), filemtime( get_stylesheet_directory() . '/style.css'));
// 	wp_enqueue_style( 'tegal-blocks-style', get_template_directory_uri() . '/style.css', array(), wp_get_theme(get_template())->get( 'Version' ) );
	wp_enqueue_style( 'tegal-blocks-style-blocks', get_template_directory_uri() . '/assets/css/blocks.css', array(), wp_get_theme(get_template())->get( 'Version' ) );
	wp_enqueue_style( 'tegal-blocks-style-shared', get_template_directory_uri() . '/assets/css/style-shared.css', array(), wp_get_theme(get_template())->get( 'Version' ) );
}
add_action( 'wp_enqueue_scripts', 'tegal_blocks_scripts' );

/**
 * Enqueue block editor script.
 *
 * @since 1.0
 *
 * @return void
 */
function tegal_blocks_block_editor_script() {

	wp_enqueue_script( 'tegal-blocks-unregister-block-style', get_theme_file_uri( '/assets/js/unregister-block-style.js' ), array( 'wp-blocks', 'wp-dom' ), wp_get_theme()->get( 'Version' ), true );
}
add_action( 'enqueue_block_editor_assets', 'tegal_blocks_block_editor_script' );

/**
 * Body Class.
 *
 * @since 1.0
 *
 * @return void
 */
function add_tegal_body_class( $classes ) {
	$classes[] = 'tegal-body';
	return $classes;
}
add_filter( 'body_class', 'add_tegal_body_class' );

/**
 * Admin Body Class.
 *
 * @since 1.0
 *
 * @return void
 */
function add_tegal_admin_body_class( $classes ) {
	$classes .= 'tegal-admin-body';
	return $classes;
}
add_filter( 'admin_body_class', 'add_tegal_admin_body_class' );

/**
 * Block Patterns.
 *
 * @since 1.0
 *
 * @return void
 */
require get_template_directory() . '/inc/block-patterns.php';

/**
 * Block Styles.
 *
 * @since 1.0
 *
 * @return void
 */
require get_template_directory() . '/inc/block-styles.php';

/**
 * Theme Update
 *
 * @since 1.0
 *
 * @return void
 */
require 'lib/plugin-update-checker/plugin-update-checker.php';
Puc_v4_Factory::buildUpdateChecker(
	'https://tegal.one-ap-engineer.com/wp-content/uploads/5s0pe9qpow42ke50jkb2/theme-update.json',
	 __FILE__,
	 'tegal'
);
