<?php
/**
 * Block Patterns
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_pattern/
 * @link https://developer.wordpress.org/reference/functions/register_block_pattern_category/
 *
 * @package DotBlocks
 * @since 1.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	// LP
	register_block_pattern_category(
		'tegal-lp',
		array( 'label' => esc_html__( 'Tegal LP', 'tegal' ) )
	);
	// Eye Catch
	register_block_pattern_category(
		'tegal-eyecatch',
		array( 'label' => esc_html__( 'Tegal Eye Catch', 'tegal' ) )
	);
	// STEPS
	register_block_pattern_category(
		'tegal-steps',
		array( 'label' => esc_html__( 'Tegal Steps', 'tegal' ) )
	);
	// Compare Other Prod
	register_block_pattern_category(
		'tegal-compare',
		array( 'label' => esc_html__( 'Tegal Compare Others', 'tegal' ) )
	);
	// Course & Price
	register_block_pattern_category(
		'tegal-course',
		array( 'label' => esc_html__( 'Tegal Course & Price', 'tegal' ) )
	);
	// Customer Voice
	register_block_pattern_category(
		'tegal-voice',
		array( 'label' => esc_html__( 'Tegal Customer Voice', 'tegal' ) )
	);
	// FAQ
	register_block_pattern_category(
		'tegal-faq',
		array( 'label' => esc_html__( 'Tegal FAQ', 'tegal' ) )
	);
	// Show Case
	register_block_pattern_category(
		'tegal-showcase',
		array( 'label' => esc_html__( 'Tegal Show Case', 'tegal' ) )
	);
	// Contents Parts
	register_block_pattern_category(
		'tegal-parts',
		array( 'label' => esc_html__( 'Tegal Parts', 'tegal' ) )
	);
	// Deco Tables （追加要否検討中）
	
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {

	// tegal-eyecatch Text and Image 01
	register_block_pattern(
		'tegal-eyecatch/text-and-image-01',
		array(
			'title'         => esc_html__( 'Text and Image 01', 'tegal' ),
			'categories'    => array( 'tegal-eyecatch' ),
			'viewportWidth' => 1440,
			'description'   => esc_html_x( 'For Eye Catch Area', 'tegal' ),
			'content'       => '
<!-- wp:button {"style":{"border":{"radius":"0px"},"spacing":{"padding":{"top":"0.4rem","right":"0.8rem","bottom":"0.4rem","left":"0.8rem"}}},"className":"is-style-tegal-button-shadow"} -->
<div class="wp-block-button is-style-tegal-button-shadow"><a class="wp-block-button__link" style="border-radius:0px;padding-top:0.4rem;padding-right:0.8rem;padding-bottom:0.4rem;padding-left:0.8rem">ダウンロード</a></div>
<!-- /wp:button -->
			',
		)
	);

	// Steps 01.
	register_block_pattern(
		'tegal-steps/steps-01',
		array(
			'title'         => esc_html__( 'Steps 01', 'tegal' ),
			'categories'    => array( 'tegal-steps' ),
			'viewportWidth' => 1440,
			'description'   => esc_html_x( 'Action Steps', 'tegal' ),
			'content'       => '
<!-- wp:columns {"align":"full","style":{"color":{"background":"#f0eaf5"}}} -->
<div class="wp-block-columns alignfull has-background" style="background-color:#f0eaf5"><!-- wp:column {"width":"100%"} -->
<div class="wp-block-column" style="flex-basis:100%"><!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center" id="ランディングページには正しい作り方があります">ランディングページには正しい作り方があります</h2>
<!-- /wp:heading -->

<!-- wp:group {"className":"is-style-tegal-group-steps","layout":{"inherit":true}} -->
<div class="wp-block-group is-style-tegal-group-steps"><!-- wp:group {"className":"is-style-default"} -->
<div class="wp-block-group is-style-default"><!-- wp:columns {"align":"full","className":"is-style-default"} -->
<div class="wp-block-columns alignfull is-style-default"><!-- wp:column {"verticalAlignment":"center","className":"is-style-default"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-default"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center" id="1-商品選定">1.商品選定</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">ランディングページで販促したい商品・サービスを選定しましょう。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":362,"width":400,"height":400,"sizeSlug":"full","linkDestination":"none","className":"is-style-rounded"} -->
<figure class="wp-block-image size-full is-resized is-style-rounded"><img src="https://tegal.one-ap-engineer.com/wp-content/uploads/2021/12/select-prod-image.png" alt="" class="wp-image-362" width="400" height="400"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group -->
<div class="wp-block-group"><!-- wp:columns {"align":"full","className":"is-style-tegal-column-direction-col-reverse"} -->
<div class="wp-block-columns alignfull is-style-tegal-column-direction-col-reverse"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":373,"sizeSlug":"full","linkDestination":"none","className":"is-style-rounded"} -->
<figure class="wp-block-image size-full is-style-rounded"><img src="https://tegal.one-ap-engineer.com/wp-content/uploads/2021/12/target-setting-image.png" alt="" class="wp-image-373"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","className":"is-style-default"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-default"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center" id="2-ターゲティング-1">2.ターゲティング</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">どんな人に訴求したいかを考えましょう。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group -->
<div class="wp-block-group"><!-- wp:columns {"align":"full","className":"is-style-default"} -->
<div class="wp-block-columns alignfull is-style-default"><!-- wp:column {"verticalAlignment":"center","className":"is-style-default"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-default"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center" id="3-ゴール設定-1">3.ゴール設定</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">ランディングページで何を実現をしたいか決めます。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":365,"sizeSlug":"full","linkDestination":"none","className":"is-style-rounded"} -->
<figure class="wp-block-image size-full is-style-rounded"><img src="https://tegal.one-ap-engineer.com/wp-content/uploads/2021/12/goal-setting-image.png" alt="" class="wp-image-365"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group -->
<div class="wp-block-group"><!-- wp:columns {"align":"full","className":"is-style-tegal-column-direction-col-reverse"} -->
<div class="wp-block-columns alignfull is-style-tegal-column-direction-col-reverse"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":375,"sizeSlug":"full","linkDestination":"none","className":"is-style-rounded"} -->
<figure class="wp-block-image size-full is-style-rounded"><img src="https://tegal.one-ap-engineer.com/wp-content/uploads/2021/12/structure-desing-image.png" alt="" class="wp-image-375"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","className":"is-style-default"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-default"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center" id="4-構成デザイン-1">4.構成デザイン</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">ランディングページの構成をデザインします。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group -->
<div class="wp-block-group"><!-- wp:columns {"align":"full","className":"is-style-default"} -->
<div class="wp-block-columns alignfull is-style-default"><!-- wp:column {"verticalAlignment":"center","className":"is-style-default"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-default"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center" id="5-ビジュアルデザイン-1">5.ビジュアルデザイン</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">デザインを設計します。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":368,"sizeSlug":"full","linkDestination":"none","className":"is-style-rounded"} -->
<figure class="wp-block-image size-full is-style-rounded"><img src="https://tegal.one-ap-engineer.com/wp-content/uploads/2021/12/visual-design-image.png" alt="" class="wp-image-368"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group -->
<div class="wp-block-group"><!-- wp:columns {"align":"full","className":"is-style-tegal-column-direction-col-reverse"} -->
<div class="wp-block-columns alignfull is-style-tegal-column-direction-col-reverse"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":378,"sizeSlug":"full","linkDestination":"none","className":"is-style-rounded"} -->
<figure class="wp-block-image size-full is-style-rounded"><img src="https://tegal.one-ap-engineer.com/wp-content/uploads/2021/12/web-coding-image.png" alt="" class="wp-image-378"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","className":"is-style-default"} -->
<div class="wp-block-column is-vertically-aligned-center is-style-default"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center" id="6-コーディング-1">6.コーディング</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">設計をもとにコーディングを行います。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->
			',
		)
	);

	// Course & Price
	register_block_pattern(
		'tegal-course/course-price-01',
		array(
			'title'         => esc_html__( 'Course and Price 01', 'tegal' ),
			'categories'    => array( 'tegal-course' ),
			'viewportWidth' => 1440,
			'description'   => esc_html_x( 'Course and Price.', 'tegal' ),
			'content'       => '
<!-- wp:columns {"align":"wide","backgroundColor":"white"} -->
<div class="wp-block-columns alignwide has-white-background-color has-background"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center" id="サービスとご利用料金">サービスとご利用料金</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">現在、全て無料でご利用頂けます。</p>
<!-- /wp:paragraph -->

<!-- wp:columns {"className":"is-style-tegal-column-x-scroll"} -->
<div class="wp-block-columns is-style-tegal-column-x-scroll"><!-- wp:column {"style":{"spacing":{"padding":{"top":"1rem","right":"1rem","bottom":"1rem","left":"1rem"}}}} -->
<div class="wp-block-column" style="padding-top:1rem;padding-right:1rem;padding-bottom:1rem;padding-left:1rem"><!-- wp:group {"style":{"border":{"style":"solid","width":"2px"},"spacing":{"padding":{"top":"0.5rem","right":"0.5rem","bottom":"0.5rem","left":"0.5rem"}}},"borderColor":"cyan-bluish-gray","className":"is-style-tegal-group-card"} -->
<div class="wp-block-group is-style-tegal-group-card has-border-color has-cyan-bluish-gray-border-color" style="border-style:solid;border-width:2px;padding-top:0.5rem;padding-right:0.5rem;padding-bottom:0.5rem;padding-left:0.5rem"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center" id="テーマ利用-1">テーマ利用</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">無料</p>
<!-- /wp:paragraph -->

<!-- wp:separator -->
<hr class="wp-block-separator"/>
<!-- /wp:separator -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">GPLライセンスのため、利用サイト数の制限はありません。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"padding":{"top":"1rem","right":"1rem","bottom":"1rem","left":"1rem"}}}} -->
<div class="wp-block-column" style="padding-top:1rem;padding-right:1rem;padding-bottom:1rem;padding-left:1rem"><!-- wp:group {"style":{"border":{"width":"2px","style":"solid"},"spacing":{"padding":{"top":"0.5rem","right":"0.5rem","bottom":"0.5rem","left":"0.5rem"}}},"borderColor":"cyan-bluish-gray","className":"is-style-tegal-group-card"} -->
<div class="wp-block-group is-style-tegal-group-card has-border-color has-cyan-bluish-gray-border-color" style="border-style:solid;border-width:2px;padding-top:0.5rem;padding-right:0.5rem;padding-bottom:0.5rem;padding-left:0.5rem"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center" id="フォーラム利用-1">フォーラム利用</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">無料</p>
<!-- /wp:paragraph -->

<!-- wp:separator -->
<hr class="wp-block-separator"/>
<!-- /wp:separator -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">ユーザー専用フォーラムにご登録・投稿いただけます。なお、フォーラムはまだ作成していません。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"padding":{"top":"1rem","right":"1rem","bottom":"1rem","left":"1rem"}}}} -->
<div class="wp-block-column" style="padding-top:1rem;padding-right:1rem;padding-bottom:1rem;padding-left:1rem"><!-- wp:group {"style":{"spacing":{"padding":{"top":"0.5rem","right":"0.5rem","bottom":"0.5rem","left":"0.5rem"}},"border":{"style":"solid","width":"2px"}},"borderColor":"cyan-bluish-gray","className":"is-style-tegal-group-card"} -->
<div class="wp-block-group is-style-tegal-group-card has-border-color has-cyan-bluish-gray-border-color" style="border-style:solid;border-width:2px;padding-top:0.5rem;padding-right:0.5rem;padding-bottom:0.5rem;padding-left:0.5rem"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center" id="サポート-1">サポート</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">無料</p>
<!-- /wp:paragraph -->

<!-- wp:separator -->
<hr class="wp-block-separator"/>
<!-- /wp:separator -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">フォーラムを通してご質問頂いた内容に回答致します。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"padding":{"top":"1rem","right":"1rem","bottom":"1rem","left":"1rem"}}}} -->
<div class="wp-block-column" style="padding-top:1rem;padding-right:1rem;padding-bottom:1rem;padding-left:1rem"><!-- wp:group {"style":{"spacing":{"padding":{"top":"0.5rem","right":"0.5rem","bottom":"0.5rem","left":"0.5rem"}},"border":{"style":"solid","width":"2px"}},"borderColor":"cyan-bluish-gray","className":"is-style-tegal-group-card"} -->
<div class="wp-block-group is-style-tegal-group-card has-border-color has-cyan-bluish-gray-border-color" style="border-style:solid;border-width:2px;padding-top:0.5rem;padding-right:0.5rem;padding-bottom:0.5rem;padding-left:0.5rem"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center" id="その他">その他</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">無料</p>
<!-- /wp:paragraph -->

<!-- wp:separator -->
<hr class="wp-block-separator"/>
<!-- /wp:separator -->

<!-- wp:paragraph {"align":"center","className":"is-style-armando-rounded-corners"} -->
<p class="has-text-align-center is-style-armando-rounded-corners">BOX4つ作ってみたら、書くことが無くなりました。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->
			',
		)
	);

	// LP hogehoge.
	register_block_pattern(
		'tegal-faq/faq-01',
		array(
			'title'         => esc_html__( 'FAQ 01', 'tegal' ),
			'categories'    => array( 'tegal-faq' ),
			'viewportWidth' => 1440,
			'description'   => esc_html_x( 'Official Information such as Adress.', 'tegal' ),
			'content'       => '
<!-- wp:columns {"align":"full","style":{"color":{"background":"#f0eaf5"}}} -->
<div class="wp-block-columns alignfull has-background" style="background-color:#f0eaf5"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center" id="よくあるご質問">よくあるご質問</h2>
<!-- /wp:heading -->

<!-- wp:group {"layout":{"inherit":true}} -->
<div class="wp-block-group"><!-- wp:group {"className":"is-style-tegal-group-faq"} -->
<div class="wp-block-group is-style-tegal-group-faq"><!-- wp:paragraph {"className":"is-style-armando-rounded-corners"} -->
<p class="is-style-armando-rounded-corners">利用料金はかかりますか？</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"is-style-armando-rounded-corners"} -->
<p class="is-style-armando-rounded-corners">1円もかかりません。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:separator {"className":"is-style-dots"} -->
<hr class="wp-block-separator is-style-dots"/>
<!-- /wp:separator -->

<!-- wp:group {"className":"is-style-tegal-group-faq"} -->
<div class="wp-block-group is-style-tegal-group-faq"><!-- wp:paragraph {"className":"is-style-armando-rounded-corners"} -->
<p class="is-style-armando-rounded-corners">複数のサイトに利用可能ですか？</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"is-style-armando-rounded-corners"} -->
<p class="is-style-armando-rounded-corners">はい、複数サイトにご利用いただいて構いません。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:separator {"className":"is-style-dots"} -->
<hr class="wp-block-separator is-style-dots"/>
<!-- /wp:separator -->

<!-- wp:group {"className":"is-style-tegal-group-faq"} -->
<div class="wp-block-group is-style-tegal-group-faq"><!-- wp:paragraph {"className":"is-style-armando-rounded-corners"} -->
<p class="is-style-armando-rounded-corners">サポートは受けられますか？</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"className":"is-style-armando-rounded-corners"} -->
<p class="is-style-armando-rounded-corners">利用者フォーラムよりサポート可能です。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:separator {"className":"is-style-dots"} -->
<hr class="wp-block-separator is-style-dots"/>
<!-- /wp:separator -->

<!-- wp:group {"className":"is-style-tegal-group-faq"} -->
<div class="wp-block-group is-style-tegal-group-faq"><!-- wp:paragraph {"className":"is-style-armando-rounded-corners"} -->
<p class="is-style-armando-rounded-corners">FAQのスタイルで箇条書きは使えますか？</p>
<!-- /wp:paragraph -->

<!-- wp:group -->
<div class="wp-block-group"><!-- wp:paragraph {"className":"is-style-armando-rounded-corners"} -->
<p class="is-style-armando-rounded-corners">グループブロックに変更することで利用可能です。</p>
<!-- /wp:paragraph -->

<!-- wp:list -->
<ul><li>リスト要素１</li><li>リスト要素２</li><li>リスト要素３</li></ul>
<!-- /wp:list -->

<!-- wp:paragraph {"className":"is-style-armando-rounded-corners"} -->
<p class="is-style-armando-rounded-corners">といった具合に。</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":18} -->
<div style="height:18px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->
			',
		)
	);

}
